package org.elsfs.tool.sql.resolve;

import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 解析枚举字段
 *
 * @author zeng
 * @since 0.0.4
 */
public interface ResolveFieldName {
  /**
   * 解析字段枚举名称
   *
   * @param field 字段枚举
   * @return 字段名称
   */
  String resolveFieldName(Enum<?> field);

  /**
   * 解析字段枚举名称
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return 字段名称
   */
  default String resolveFieldName(String tableAlias, Enum<?> field) {
    return tableAlias + SqlPool.DOT + field.name();
  }
}
