package org.elsfs.tool.sql.singular.facade;

import java.util.List;
import org.elsfs.tool.core.page.IPage;

/**
 * 动作执行器
 *
 * @param <E> 实体类型
 * @author zeng
 * @since 0.0.4
 */
public interface DbActionFactory<E> {

  /**
   * 创建一个单记录查询动作
   *
   * @return 查询动作对象
   */
  QueryAction<E> queryOne();

  /**
   * 创建一个多记录查询动作
   *
   * @return 查询动作对象
   */
  QueryAction<List<E>> queryList();

  /**
   * 创建一个分页查询动作
   *
   * @return 分页查询动作对象
   */
  QueryAction<IPage<E>> queryPage();

  /**
   * 创建一个统计查询动作
   *
   * @return 统计动作对象
   */
  QueryAction<Long> count();

  /**
   * 创建一个存在查询动作
   *
   * @return 存在动作对象
   */
  QueryAction<Boolean> exists();

  /**
   * 创建一个更新动作
   *
   * @return 更新动作对象
   */
  UpdateAction<Long> update();

  /**
   * 创建一个删除动作
   *
   * @return 删除动作对象
   */
  DeletionAction<Long> delete();
}
