package org.elsfs.tool.sql.union;

import org.elsfs.tool.core.util.CharSequenceUtil;
import org.elsfs.tool.sql.interfaces.SqlFragment;

/**
 * 联合项
 *
 * @author zeng
 * @version 0.0.4
 */
public interface UnionItem extends SqlFragment {

  /**
   * 剔除条件SQL头部多余的关键词
   *
   * @param unionSql 联合SQL
   * @return 合理的联合SQL
   */
  static String stripHeaderKeyword(String unionSql) {
    if (unionSql.startsWith("UNION ")) {
      return CharSequenceUtil.strip(unionSql, "UNION ");
    }

    if (unionSql.startsWith("UNION ALL ")) {
      return CharSequenceUtil.strip(unionSql, "UNION ALL ");
    }

    return unionSql;
  }
}
