package org.elsfs.tool.sql.update;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.utils.SqlUtils;

/**
 * 表达式设置项实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class ExpressionSetItem implements SetItem {

  /** 字段名称 */
  private final String field;

  /** 字段表达式 */
  private final String expression;

  /** 表达式参数 */
  private final Object[] args;

  /**
   * 构建设置项
   *
   * @param field 字段名称
   * @param expression 字段表达式
   * @param args 表达式参数
   */
  public ExpressionSetItem(String field, String expression, Object[] args) {
    this.field = field;
    this.expression = expression;
    this.args = args;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} = {}",
        NamingCase.toUnderlineCase(this.field),
        SqlUtils.handleSqlExpression(this.expression, this.args));
  }
}
