package org.elsfs.tool.sql.utils;

import org.elsfs.tool.core.text.StrPool;

/**
 * the is {@link SqlPool}
 *
 * @author zeng
 * @version 0.0.4
 */
public interface SqlPool extends StrPool {
  /** 井号加左大括号 */
  String HASH_LEFT_BRACE = "#{";

  /** 右大括号 */
  String RIGHT_BRACE = "}";

  /** 数据库AS关键字 */
  String AS_KEYWORD = "AS";

  /** 带空格的数据库AS关键字 */
  String AS_KEYWORD_WITH_SPACE = SPACE + AS_KEYWORD + SPACE;

  /** 星号 */
  String ASTERISK = "*";

  /** 左小括号 */
  String LEFT_BRACKET = "(";

  /** 右小括号 */
  String RIGHT_BRACKET = ")";

  /** 宽松逗号（加空格） */
  String COMMA_WITH_SPACE = COMMA + SPACE;

  /** SQL中的NULL关键字 */
  String SQL_NULL = "NULL";
}
