/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.abs;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.sql.abs.AbstractCondition;
import org.elsfs.tool.sql.abs.AbstractJoin;
import org.elsfs.tool.sql.abs.CompositeSqlFragment;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.common.HierarchyTableAliasManager;
import org.elsfs.tool.sql.common.SimpleTableAliasManager;
import org.elsfs.tool.sql.condition.ConditionItem;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.interfaces.Join;
import org.elsfs.tool.sql.interfaces.JoinType;
import org.elsfs.tool.sql.interfaces.SqlFragment;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;
import org.elsfs.tool.sql.interfaces.SqlParameterManagerAware;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.interfaces.TableAliasManagerAware;
import org.elsfs.tool.sql.interfaces.TokenSqlFragment;
import org.elsfs.tool.sql.utils.CastUtils;

public abstract class AbstractJoin<C extends AbstractJoin<C>>
extends CompositeSqlFragment
implements Join<C, JoinBuilderImpl, JoinConditionBuilderImpl>,
SqlParameterManagerAware,
TableAliasManagerAware {
    protected final C childThis = (AbstractJoin)CastUtils.cast(this);
    private final List<JoinBuilderImpl> joinBuilders = new ArrayList<JoinBuilderImpl>();

    protected abstract String getTableName(Class<?> var1);

    @Override
    public JoinBuilderImpl join(Class<?> entityClass, String tableAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.INNER_JOIN, this.getTableName(entityClass), tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl join(Class<?> entityClass) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.INNER_JOIN, this.getTableName(entityClass));
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl join(String table) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.INNER_JOIN, table);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl join(Class<?> entityClass, String tableAlias, boolean registerAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.INNER_JOIN, this.getTableName(entityClass), tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl join(String table, String tableAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.INNER_JOIN, table, tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl join(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias) {
        return this.doSubQueryJoin(sqlBuilderConsumer, tableAlias, JoinType.INNER_JOIN);
    }

    @Override
    public JoinBuilderImpl join(String table, String tableAlias, boolean registerAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.INNER_JOIN, table, tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl leftJoin(Class<?> entityClass, String tableAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.LEFT_JOIN, this.getTableName(entityClass), tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl leftJoin(Class<?> entityClass, String tableAlias, boolean registerAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.LEFT_JOIN, this.getTableName(entityClass), tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl leftJoin(String table) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.LEFT_JOIN, table);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl leftJoin(String table, String tableAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.LEFT_JOIN, table, tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl leftJoin(Class<?> entityClass) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.LEFT_JOIN, this.getTableName(entityClass));
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl leftJoin(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias) {
        return this.doSubQueryJoin(sqlBuilderConsumer, tableAlias, JoinType.LEFT_JOIN);
    }

    @Override
    public JoinBuilderImpl leftJoin(String table, String tableAlias, boolean registerAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.LEFT_JOIN, table, tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl rightJoin(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias) {
        return this.doSubQueryJoin(sqlBuilderConsumer, tableAlias, JoinType.RIGHT_JOIN);
    }

    @Override
    public JoinBuilderImpl rightJoin(Class<?> entityClass) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.RIGHT_JOIN, this.getTableName(entityClass));
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl rightJoin(Class<?> entityClass, String tableAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.RIGHT_JOIN, this.getTableName(entityClass), tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl rightJoin(Class<?> entityClass, String tableAlias, boolean registerAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.RIGHT_JOIN, this.getTableName(entityClass), tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl rightJoin(String table) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.RIGHT_JOIN, table);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl rightJoin(String table, String tableAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.RIGHT_JOIN, table, tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    public JoinBuilderImpl rightJoin(String table, String tableAlias, boolean registerAlias) {
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(JoinType.RIGHT_JOIN, table, tableAlias, registerAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    private JoinBuilderImpl doSubQueryJoin(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias, JoinType joinType) {
        if (StrUtils.isBlank((String)tableAlias)) {
            throw new SqlBuilderException("JOIN\u5b50\u67e5\u8be2\u7684\u8868\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StandardSelectSql standardSelectSql = new StandardSelectSql(this.getSqlParameterManager(), new HierarchyTableAliasManager(new SimpleTableAliasManager(), this.getTableAliasManager()));
        sqlBuilderConsumer.accept(standardSelectSql);
        JoinBuilderImpl joinBuilder = new JoinBuilderImpl(joinType, "(" + standardSelectSql.buildSqlFragment() + ")", tableAlias);
        this.joinBuilders.add(joinBuilder);
        return joinBuilder;
    }

    @Override
    protected void beforeBuild() {
        for (JoinBuilderImpl joinBuilder : this.joinBuilders) {
            this.addSqlFragment(joinBuilder);
        }
    }

    public class JoinBuilderImpl
    extends CompositeSqlFragment
    implements Join.JoinBuilder<JoinBuilderImpl, org.elsfs.tool.sql.abs.AbstractJoin$JoinBuilderImpl.JoinConditionBuilderImpl, C>,
    SqlParameterManagerAware,
    TableAliasManagerAware {
        private final JoinType joinType;
        private final String table;
        private final String tableAlias;
        private org.elsfs.tool.sql.abs.AbstractJoin$JoinBuilderImpl.JoinConditionBuilderImpl joinConditionBuilder;

        public JoinBuilderImpl(JoinType joinType, String table, String tableAlias, boolean registerAlias) {
            this.joinType = joinType;
            this.table = table;
            this.tableAlias = tableAlias;
            if (registerAlias) {
                this.getTableAliasManager().registerAlias(table, tableAlias);
            }
        }

        public JoinBuilderImpl(JoinType joinType, String table, String tableAlias) {
            this(joinType, table, tableAlias, true);
        }

        public JoinBuilderImpl(JoinType joinType, String table) {
            this(joinType, table, this$0.getTableAliasManager().generateAlias(table), true);
        }

        @Override
        public C end() {
            return AbstractJoin.this.childThis;
        }

        @Override
        public org.elsfs.tool.sql.abs.AbstractJoin$JoinBuilderImpl.JoinConditionBuilderImpl on() {
            this.joinConditionBuilder = new JoinConditionBuilderImpl();
            return this.joinConditionBuilder;
        }

        @Override
        protected void beforeBuild() {
            this.addSqlFragment(new TokenSqlFragment(this.joinType.getJoinKeyword()));
            this.addSqlFragment(new TokenSqlFragment(this.table + " AS " + this.tableAlias));
            this.addSqlFragment((SqlFragment)this.joinConditionBuilder);
        }

        @Override
        public SqlParameterManager getSqlParameterManager() {
            return AbstractJoin.this.getSqlParameterManager();
        }

        @Override
        public TableAliasManager getTableAliasManager() {
            return AbstractJoin.this.getTableAliasManager();
        }

        public class JoinConditionBuilderImpl
        extends AbstractCondition<org.elsfs.tool.sql.abs.AbstractJoin$JoinBuilderImpl.JoinConditionBuilderImpl>
        implements Join.JoinConditionBuilder<org.elsfs.tool.sql.abs.AbstractJoin$JoinBuilderImpl.JoinConditionBuilderImpl, JoinBuilderImpl, C> {
            private final List<ConditionItem> conditionItems = new ArrayList<ConditionItem>();

            @Override
            public SqlParameterManager getSqlParameterManager() {
                return JoinBuilderImpl.this.getSqlParameterManager();
            }

            @Override
            protected void addConditionItem(ConditionItem conditionItem) {
                this.conditionItems.add(conditionItem);
            }

            @Override
            public C end() {
                return JoinBuilderImpl.this.end();
            }

            @Override
            public String buildSqlFragment() {
                if (this.conditionItems.isEmpty()) {
                    return "";
                }
                return StrFormatter.format((String)"ON {}", (Object[])new Object[]{ConditionItem.stripHeaderKeywordStatic(this.conditionItems.stream().map(SqlFragment::buildSqlFragment).collect(Collectors.joining(" ")))});
            }

            @Override
            public TableAliasManager getTableAliasManager() {
                return JoinBuilderImpl.this.getTableAliasManager();
            }
        }
    }
}

