/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.abs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.elsfs.tool.core.text.ArrayUtils;
import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.core.util.CollectionUtils;
import org.elsfs.tool.sql.abs.AbstractSelectCondition;
import org.elsfs.tool.sql.abs.AbstractSelectJoin;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.common.FieldEnumResolverSupport;
import org.elsfs.tool.sql.common.HierarchyTableAliasManager;
import org.elsfs.tool.sql.common.SimpleTableAliasManager;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.from.FromItem;
import org.elsfs.tool.sql.from.StandardFromItem;
import org.elsfs.tool.sql.from.SubQueryFromItem;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.interfaces.select.SelectSql;
import org.elsfs.tool.sql.select.CompositeSelectItem;
import org.elsfs.tool.sql.select.ExpressionSelectItem;
import org.elsfs.tool.sql.select.SelectItem;
import org.elsfs.tool.sql.select.StandardSelectItem;
import org.elsfs.tool.sql.select.SubQuerySelectItem;
import org.elsfs.tool.sql.utils.CastUtils;

public abstract class AbstractSelectSql<C extends AbstractSelectSql<C>>
extends AbstractSelectJoin<C>
implements SelectSql<C, SelectConditionBuilderImpl, AbstractSelectCondition.HavingConditionBuilderImpl> {
    protected final C childThis = (AbstractSelectSql)CastUtils.cast(this);
    private final List<SelectItem> selectItems = new ArrayList<SelectItem>();
    private FromItem fromItem;
    private SelectConditionBuilderImpl selectConditionBuilder;

    protected String resolveFieldName(Enum<?> field) {
        return FieldEnumResolverSupport.resolveFieldName(this.getTableAliasManager(), field);
    }

    @Override
    public C select(String ... fields) {
        if (ArrayUtils.isEmpty((Object[])fields)) {
            return this.childThis;
        }
        for (String field : fields) {
            this.selectItems.add(new StandardSelectItem(field));
        }
        return this.childThis;
    }

    @Override
    public C select(Enum<?> ... fields) {
        if (ArrayUtils.isEmpty((Object[])fields)) {
            return this.childThis;
        }
        for (Enum<?> field : fields) {
            this.selectItems.add(new StandardSelectItem(this.resolveFieldName(field)));
        }
        return this.childThis;
    }

    @Override
    public C select(Collection<String> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return this.childThis;
        }
        for (String field : fields) {
            this.selectItems.add(new StandardSelectItem(field));
        }
        return this.childThis;
    }

    @Override
    public C selectExpression(String ... expressions) {
        if (ArrayUtils.isEmpty((Object[])expressions)) {
            return this.childThis;
        }
        for (String expression : expressions) {
            this.selectItems.add(new ExpressionSelectItem(expression));
        }
        return this.childThis;
    }

    @Override
    public C selectExpression(Collection<String> expressions) {
        if (CollectionUtils.isEmpty(expressions)) {
            return this.childThis;
        }
        for (String expression : expressions) {
            this.addSelectItem(new ExpressionSelectItem(expression));
        }
        return this.childThis;
    }

    @Override
    public C selectAs(String field, String fieldAlias) {
        if (StrUtils.isBlank((String)fieldAlias)) {
            throw new SqlBuilderException("\u9009\u62e9\u5b57\u6bb5[{}]\u7684\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a" + field);
        }
        this.addSelectItem(new StandardSelectItem(field + " AS " + fieldAlias));
        return this.childThis;
    }

    @Override
    public C selectAs(Enum<?> field, String fieldAlias) {
        return (C)this.selectAs(this.resolveFieldName(field), fieldAlias);
    }

    @Override
    public C selectAs(Enum<?> field, Enum<?> fieldAlias) {
        return (C)this.selectAs((Enum)field, fieldAlias.name());
    }

    @Override
    public C selectAs(Consumer<StandardSelectSql> sqlBuilderConsumer, String fieldAlias) {
        StandardSelectSql standardSelectSql = new StandardSelectSql(this.getSqlParameterManager(), new HierarchyTableAliasManager(new SimpleTableAliasManager(), this.getTableAliasManager()));
        sqlBuilderConsumer.accept(standardSelectSql);
        this.addSelectItem(new SubQuerySelectItem(standardSelectSql.buildSqlFragment(), fieldAlias));
        return this.childThis;
    }

    @Override
    public C selectAs(Consumer<StandardSelectSql> sqlBuilderConsumer, Enum<?> fieldAlias) {
        return (C)this.selectAs((Consumer)sqlBuilderConsumer, fieldAlias.name());
    }

    @Override
    public C selectEnum(Collection<Enum<?>> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return this.childThis;
        }
        for (Enum<?> field : fields) {
            this.addSelectItem(new StandardSelectItem(this.resolveFieldName(field)));
        }
        return this.childThis;
    }

    @Override
    protected void addSelectItem(SelectItem selectItem) {
        this.selectItems.add(selectItem);
    }

    @Override
    public C from(Class<?> entityClass, String tableAlias) {
        this.fromItem = new StandardFromItem(this.getTableName(entityClass), tableAlias);
        this.getTableAliasManager().registerAlias(entityClass, tableAlias);
        return this.childThis;
    }

    @Override
    public C from(String table, String tableAlias) {
        this.fromItem = new StandardFromItem(table, tableAlias);
        this.getTableAliasManager().registerAlias(table, tableAlias);
        return this.childThis;
    }

    @Override
    public C from(Class<?> entityClass) {
        this.fromItem = new StandardFromItem(this.getTableName(entityClass), "t");
        this.getTableAliasManager().registerAlias(entityClass, "t");
        return this.childThis;
    }

    @Override
    public C from(String table) {
        this.fromItem = new StandardFromItem(table, "t");
        this.getTableAliasManager().registerAlias(table, "t");
        return this.childThis;
    }

    @Override
    public C from(Consumer<StandardSelectSql> sqlBuilderConsumer, String tableAlias) {
        StandardSelectSql standardSelectSql = new StandardSelectSql(this.getSqlParameterManager(), new HierarchyTableAliasManager(new SimpleTableAliasManager(), this.getTableAliasManager()));
        sqlBuilderConsumer.accept(standardSelectSql);
        this.fromItem = new SubQueryFromItem(standardSelectSql.buildSqlFragment(), tableAlias);
        return this.childThis;
    }

    @Override
    public SelectSql.SelectConditionBuilder<SelectConditionBuilderImpl, AbstractSelectCondition.HavingConditionBuilderImpl, C> where() {
        if (this.selectConditionBuilder == null) {
            this.selectConditionBuilder = new SelectConditionBuilderImpl();
        }
        return this.selectConditionBuilder;
    }

    @Override
    protected void beforeBuild() {
        if (this.selectItems.isEmpty()) {
            this.selectItems.add(new CompositeSelectItem(List.of(new StandardSelectItem("*"))));
        } else {
            this.addSqlFragment(new CompositeSelectItem(this.selectItems.stream().map(selectItem -> {
                StandardSelectItem standardSelectItem;
                if (selectItem instanceof StandardSelectItem && StrUtils.isBlank((String)(standardSelectItem = (StandardSelectItem)selectItem).getTableAlias())) {
                    return new StandardSelectItem(this.fromItem.getTableAlias(), standardSelectItem.getField(), standardSelectItem.getFieldAlias());
                }
                return selectItem;
            }).toList()));
        }
        if (this.fromItem == null) {
            throw new SqlBuilderException("SQL\u6784\u5efa\u672a\u6307\u5b9a\u3010FROM\u3011");
        }
        this.addSqlFragment(this.fromItem);
        super.beforeBuild();
        if (this.selectConditionBuilder != null) {
            this.addSqlFragment(this.selectConditionBuilder);
        }
    }

    public class SelectConditionBuilderImpl
    extends AbstractSelectCondition<SelectConditionBuilderImpl>
    implements SelectSql.SelectConditionBuilder<SelectConditionBuilderImpl, AbstractSelectCondition.HavingConditionBuilderImpl, C> {
        @Override
        public SqlParameterManager getSqlParameterManager() {
            return AbstractSelectSql.this.getSqlParameterManager();
        }

        @Override
        public C end() {
            return AbstractSelectSql.this.childThis;
        }

        @Override
        public TableAliasManager getTableAliasManager() {
            return AbstractSelectSql.this.getTableAliasManager();
        }
    }
}

