/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.abs;

import java.util.Arrays;
import java.util.Collection;
import org.elsfs.tool.sql.abs.AbstractCondition;
import org.elsfs.tool.sql.interfaces.SortableCondition;
import org.elsfs.tool.sql.limit.LimitItem;
import org.elsfs.tool.sql.limit.StandardLimitItem;
import org.elsfs.tool.sql.order.AscOrderItem;
import org.elsfs.tool.sql.order.DescOrderItem;
import org.elsfs.tool.sql.order.OrderItem;

public abstract class AbstractSortableCondition<C extends AbstractSortableCondition<C>>
extends AbstractCondition<C>
implements SortableCondition<C> {
    @Override
    public C orderByAsc(String ... fields) {
        for (String field : fields) {
            this.addOrderItem(new AscOrderItem(field));
        }
        return (C)((AbstractSortableCondition)this.childThis);
    }

    @Override
    public C orderByAsc(Enum<?> ... fields) {
        return (C)this.orderByAsc(Arrays.stream(fields).map(this::resolveFieldName).toList());
    }

    @Override
    public C orderByAsc(Collection<String> fields) {
        for (String field : fields) {
            this.addOrderItem(new AscOrderItem(field));
        }
        return (C)((AbstractSortableCondition)this.childThis);
    }

    @Override
    public C orderByEnumAsc(Collection<Enum<?>> fields) {
        return (C)this.orderByAsc(fields.stream().map(this::resolveFieldName).toList());
    }

    @Override
    public C orderByDesc(String ... fields) {
        for (String field : fields) {
            this.addOrderItem(new DescOrderItem(field));
        }
        return (C)((AbstractSortableCondition)this.childThis);
    }

    @Override
    public C orderByDesc(Enum<?> ... fields) {
        return (C)this.orderByDesc(Arrays.stream(fields).map(this::resolveFieldName).toList());
    }

    @Override
    public C orderByDesc(Collection<String> fields) {
        for (String field : fields) {
            this.addOrderItem(new DescOrderItem(field));
        }
        return (C)((AbstractSortableCondition)this.childThis);
    }

    @Override
    public C orderByEnumDesc(Collection<Enum<?>> fields) {
        return (C)this.orderByDesc(fields.stream().map(this::resolveFieldName).toList());
    }

    @Override
    public C orderBy(boolean isAsc, String ... fields) {
        if (isAsc) {
            return (C)this.orderByAsc(fields);
        }
        return (C)this.orderByDesc(fields);
    }

    @Override
    public C orderBy(boolean isAsc, Enum<?> ... fields) {
        return (C)this.orderBy(isAsc, Arrays.stream(fields).map(this::resolveFieldName).toList());
    }

    @Override
    public C orderBy(boolean isAsc, Collection<String> fields) {
        if (isAsc) {
            return (C)this.orderByAsc((Collection)fields);
        }
        return (C)this.orderByDesc((Collection)fields);
    }

    @Override
    public C orderByEnum(boolean isAsc, Collection<Enum<?>> fields) {
        return (C)this.orderBy(isAsc, fields.stream().map(this::resolveFieldName).toList());
    }

    @Override
    public C limit(long number) {
        this.setLimitItem(new StandardLimitItem(number));
        return (C)((AbstractSortableCondition)this.childThis);
    }

    protected abstract void addOrderItem(OrderItem var1);

    protected abstract void setLimitItem(LimitItem var1);
}

