/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.abs;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.common.SimpleTableAliasManager;
import org.elsfs.tool.sql.interfaces.SqlFragment;
import org.elsfs.tool.sql.interfaces.SqlParameterManagerAware;
import org.elsfs.tool.sql.interfaces.UnionSql;
import org.elsfs.tool.sql.interfaces.UnionType;
import org.elsfs.tool.sql.union.StandardUnionItem;
import org.elsfs.tool.sql.union.UnionItem;
import org.elsfs.tool.sql.utils.CastUtils;

public abstract class AbstractUnionSql<C extends AbstractUnionSql<C>>
implements UnionSql<C>,
SqlParameterManagerAware {
    protected final C childThis = (AbstractUnionSql)CastUtils.cast(this);
    private final List<UnionItem> unionItems = new ArrayList<UnionItem>();

    @Override
    public C union(Consumer<StandardSelectSql> sqlBuilderConsumer) {
        StandardSelectSql standardSelectSql = new StandardSelectSql(this.getSqlParameterManager(), new SimpleTableAliasManager());
        sqlBuilderConsumer.accept(standardSelectSql);
        this.unionItems.add(new StandardUnionItem(standardSelectSql, UnionType.UNION));
        return this.childThis;
    }

    @Override
    public C unionAll(Consumer<StandardSelectSql> sqlBuilderConsumer) {
        StandardSelectSql standardSelectSql = new StandardSelectSql(this.getSqlParameterManager(), new SimpleTableAliasManager());
        sqlBuilderConsumer.accept(standardSelectSql);
        this.unionItems.add(new StandardUnionItem(standardSelectSql, UnionType.UNION_ALL));
        return this.childThis;
    }

    @Override
    public String buildSqlFragment() {
        if (this.unionItems.isEmpty()) {
            return "";
        }
        return UnionItem.stripHeaderKeyword(this.unionItems.stream().map(SqlFragment::buildSqlFragment).collect(Collectors.joining(" ")));
    }
}

