package org.elsfs.tool.sql.abs;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.sql.interfaces.SqlFragment;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 聚合SQL片段
 *
 * @author zeng
 * @since 0.0.4
 */
public abstract class CompositeSqlFragment implements SqlFragment {

  /** SQL片段列表 */
  private final List<SqlFragment> sqlFragments = new ArrayList<>();

  /**
   * 添加SQL片段
   *
   * @param sqlFragment SQL片段
   */
  protected void addSqlFragment(SqlFragment sqlFragment) {
    this.sqlFragments.add(sqlFragment);
  }

  /** 构建SQL之前处理 */
  protected void beforeBuild() {}

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    this.beforeBuild();
    return this.sqlFragments.stream()
        .map(SqlFragment::buildSqlFragment)
        .filter(StrUtils::isNotBlank)
        .collect(Collectors.joining(SqlPool.SPACE));
  }
}
