package org.elsfs.tool.sql.builder;

import org.elsfs.tool.sql.abs.AbstractInsertSql;
import org.elsfs.tool.sql.common.SimpleSqlParameterManager;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 通用插入SQL
 *
 * @param <C> 子类具体类型
 * @author zeng
 * @version 0.0.4
 */
public abstract class GenericInsertSql<C extends GenericInsertSql<C>> extends AbstractInsertSql<C> {

  /** SQL参数管理器 */
  private final SqlParameterManager sqlParameterManager = new SimpleSqlParameterManager();

  /**
   * 获取SQL参数管理器
   *
   * @return SQL参数管理器
   */
  @Override
  public SqlParameterManager getSqlParameterManager() {
    return this.sqlParameterManager;
  }
}
