package org.elsfs.tool.sql.builder;

import org.elsfs.tool.sql.abs.AbstractUnionSql;
import org.elsfs.tool.sql.common.SimpleSqlParameterManager;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 通用联合SQL实现
 *
 * @param <C> 子类具体类型
 * @author zeng
 * @version 0.0.4
 */
public abstract class GenericUnionSql<C extends GenericUnionSql<C>> extends AbstractUnionSql<C> {

  /** SQL参数管理器 */
  private final SqlParameterManager sqlParameterManager = new SimpleSqlParameterManager();

  /**
   * 获取SQL参数管理器
   *
   * @return SQL参数管理器
   */
  @Override
  public SqlParameterManager getSqlParameterManager() {
    return this.sqlParameterManager;
  }
}
