package org.elsfs.tool.sql.builder;

import org.elsfs.tool.sql.abs.AbstractSelectSql;
import org.elsfs.tool.sql.common.SimpleSqlParameterManager;
import org.elsfs.tool.sql.common.SimpleTableAliasManager;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;
import org.elsfs.tool.sql.interfaces.TableAliasManager;

/**
 * 标准查询SQL
 *
 * @author zeng
 * @version 0.0.4
 */
public class StandardSelectSql extends AbstractSelectSql<StandardSelectSql> {

  /** SQL参数管理器 */
  private final SqlParameterManager sqlParameterManager;

  /** 表别名管理器 */
  private final TableAliasManager tableAliasManager;

  public StandardSelectSql(
      SqlParameterManager sqlParameterManager, TableAliasManager tableAliasManager) {
    this.sqlParameterManager = sqlParameterManager;
    this.tableAliasManager = tableAliasManager;
  }

  public StandardSelectSql() {
    this.sqlParameterManager = new SimpleSqlParameterManager();
    this.tableAliasManager = new SimpleTableAliasManager();
  }

  /**
   * 获取SQL参数管理器
   *
   * @return SQL参数管理器
   */
  @Override
  public SqlParameterManager getSqlParameterManager() {
    return this.sqlParameterManager;
  }

  /**
   * 获取表别名管理器
   *
   * @return 表名别管理器
   */
  @Override
  public TableAliasManager getTableAliasManager() {
    return this.tableAliasManager;
  }

  @Override
  protected String getTableName(Class<?> entityClass) {
    // TODO
    return "";
  }
}
