package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 区间结束值条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class BetweenEndValueConditionItem implements ConditionItem {

  /** SQL参数管理器 */
  protected final SqlParameterManager sqlParameterManager;

  /** 左边字段名称 */
  protected final String leftField;

  /** 区间开始字段名称 */
  protected final String beginField;

  /** 区间结束值 */
  protected final Object endValue;

  /**
   * 构造函数
   *
   * @param sqlParameterManager SQL参数管理器
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endValue 区间结束值
   */
  public BetweenEndValueConditionItem(
      SqlParameterManager sqlParameterManager,
      String leftField,
      String beginField,
      Object endValue) {
    this.sqlParameterManager = sqlParameterManager;
    this.leftField = leftField;
    this.beginField = beginField;
    this.endValue = endValue;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} BETWEEN {} AND {}",
        NamingCase.toUnderlineCase(this.leftField),
        NamingCase.toUnderlineCase(this.beginField),
        SqlParameterManager.buildParameterPlaceholder(
            this.sqlParameterManager.registerParameter(this.endValue)));
  }
}
