package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 区间值条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class BetweenValueConditionItem implements ConditionItem {

  /** SQL参数管理器 */
  protected final SqlParameterManager sqlParameterManager;

  /** 左边字段名称 */
  protected final String leftField;

  /** 区间开始值 */
  protected final Object beginValue;

  /** 区间结束值 */
  protected final Object endValue;

  /**
   * 构造函数
   *
   * @param sqlParameterManager SQL参数管理器
   * @param leftField 左边字段名称
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   */
  public BetweenValueConditionItem(
      SqlParameterManager sqlParameterManager,
      String leftField,
      Object beginValue,
      Object endValue) {
    this.sqlParameterManager = sqlParameterManager;
    this.leftField = leftField;
    this.beginValue = beginValue;
    this.endValue = endValue;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} BETWEEN {} AND {}",
        NamingCase.toUnderlineCase(this.leftField),
        SqlParameterManager.buildParameterPlaceholder(
            this.sqlParameterManager.registerParameter(this.beginValue)),
        SqlParameterManager.buildParameterPlaceholder(
            this.sqlParameterManager.registerParameter(this.endValue)));
  }
}
