package org.elsfs.tool.sql.condition;

/**
 * 比较操作符
 *
 * @author zeng
 * @version 0.0.4
 */
public enum CompareOperator {

  /** 等于 */
  EQUAL(" = "),
  /** 不等于 */
  NOT_EQUAL(" <> "),
  /** 小于 */
  LESS_THAN(" < "),
  /** 小于等于 */
  LESS_THAN_OR_EQUAL(" <= "),
  /** 大于 */
  GREATER_THAN(" > "),
  /** 大于等于 */
  GREATER_THAN_OR_EQUAL(" >= ");

  CompareOperator(String operator) {
    this.operator = operator;
  }

  /** 操作符 */
  private final String operator;

  public String getOperator() {
    return operator;
  }
}
