package org.elsfs.tool.sql.condition;

import org.elsfs.tool.sql.utils.SqlUtils;

/**
 * 表达式条件项
 *
 * @author zeng
 * @version 0.0.4
 */
public class ExpressionConditionItem implements ConditionItem {

  /** 表达式 */
  private final String expression;

  /** 表达式参数 */
  private final Object[] args;

  public ExpressionConditionItem(String expression, Object[] args) {
    this.expression = expression;
    this.args = args;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return SqlUtils.handleSqlExpression(this.expression, this.args);
  }
}
