package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;

/**
 * 字段子查询条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class FieldSubQueryConditionItem implements ConditionItem {

  /** 左边字段名称 */
  private final String leftField;

  /** 右边SQL */
  private final String rightSql;

  /** 条件操作符 */
  private final CompareOperator compareOperator;

  /**
   * 构造函数
   *
   * @param leftField 左边字段名称
   * @param rightSql 条件操作符
   * @param compareOperator 条件操作符
   */
  public FieldSubQueryConditionItem(
      String leftField, String rightSql, CompareOperator compareOperator) {
    this.leftField = leftField;
    this.rightSql = rightSql;
    this.compareOperator = compareOperator;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{}{}({})",
        NamingCase.toUnderlineCase(this.leftField),
        this.compareOperator.getOperator(),
        this.rightSql);
  }
}
