package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;

/**
 * 子查询范围条件
 *
 * @author venus
 * @version 1.0.0
 * @since 2022/10/25 星期二 18:52
 */
public class InSubQueryConditionItem implements ConditionItem {

  /** 左边字段名称 */
  protected final String leftField;

  /** 子查询SQL */
  protected final String inSql;

  public InSubQueryConditionItem(String leftField, String inSql) {
    this.leftField = leftField;
    this.inSql = inSql;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} IN ({})", NamingCase.toUnderlineCase(this.leftField), this.inSql);
  }
}
