package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.StrFormatter;

/**
 * 子查询非空条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class IsNotNullSubQueryConditionItem extends IsNullSubQueryConditionItem {

  public IsNotNullSubQueryConditionItem(String sql) {
    super(sql);
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format("({}) IS NOT NULL", this.sql);
  }
}
