package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;

/**
 * 为空条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class IsNullConditionItem implements ConditionItem {

  /** 字段名称 */
  protected final String field;

  public IsNullConditionItem(String field) {
    this.field = field;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format("{} IS NULL", NamingCase.toUnderlineCase(this.field));
  }
}
