package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.StrFormatter;

/**
 * 子查询为空条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class IsNullSubQueryConditionItem implements ConditionItem {

  /** SQL */
  protected final String sql;

  public IsNullSubQueryConditionItem(String sql) {
    this.sql = sql;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format("({}) IS NULL", this.sql);
  }
}
