package org.elsfs.tool.sql.condition;

import org.elsfs.tool.core.text.StrFormatter;

/**
 * Or条件
 *
 * @author zeng
 * @version 0.0.4
 */
public class OrConditionItem implements ConditionItem {

  /** 条件项 */
  private final ConditionItem conditionItem;

  public OrConditionItem(ConditionItem conditionItem) {
    this.conditionItem = conditionItem;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format("OR {}", this.conditionItem.buildSqlFragment());
  }
}
