package org.elsfs.tool.sql.executor;

import java.util.List;
import org.elsfs.tool.sql.builder.GenericUnionSql;
import org.elsfs.tool.sql.interfaces.SqlExecutor;

/**
 * 联合SQL执行器实现
 *
 * @param <R> 结果类型
 * @author zeng
 * @version 0.0.4
 */
public class UnionSqlExecutor<R> extends GenericUnionSql<UnionSqlExecutor<R>>
    implements SqlExecutor<List<R>> {

  /** 通用SQL执行器 */
  private final GenericSqlExecutor genericSqlExecutor;

  /** 结果类 */
  private final Class<R> clazz;

  public UnionSqlExecutor(GenericSqlExecutor genericSqlExecutor, Class<R> clazz) {
    this.genericSqlExecutor = genericSqlExecutor;
    this.clazz = clazz;
  }

  /**
   * 执行SQL
   *
   * @return 结果
   */
  @Override
  public List<R> execute() {
    return this.genericSqlExecutor.selectList(
        this.buildSqlFragment(), this.getSqlParameterManager().getSqlParameters(), this.clazz);
  }
}
