package org.elsfs.tool.sql.insert;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 标准实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class StandardValuesItem implements ValuesItem {

  /** SQL参数管理器 */
  protected final SqlParameterManager sqlParameterManager;

  /** 插入字段集合 */
  private final Collection<String> insertFields;

  /** 值集合 */
  private final Collection<Map<String, Object>> values;

  /**
   * 构造函数
   *
   * @param sqlParameterManager SQL参数管理器
   * @param insertFields 插入字段集合
   * @param values 值集合
   */
  public StandardValuesItem(
      SqlParameterManager sqlParameterManager,
      Collection<String> insertFields,
      Collection<Map<String, Object>> values) {
    this.sqlParameterManager = sqlParameterManager;
    this.insertFields = insertFields;
    this.values = values;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    if (this.values.isEmpty()) {
      return "VALUES";
    }

    return StrFormatter.format(
        "VALUES {}",
        this.values.stream()
            .map(
                value ->
                    StrFormatter.format(
                        "({})",
                        this.insertFields.stream()
                            .map(
                                field -> {
                                  Object v = value.get(field);
                                  if (v == null) {
                                    return SqlPool.SQL_NULL;
                                  }

                                  return SqlParameterManager.buildParameterPlaceholder(
                                      this.sqlParameterManager.registerParameter(v));
                                })
                            .collect(Collectors.joining(SqlPool.COMMA_WITH_SPACE))))
            .collect(Collectors.joining(SqlPool.COMMA_WITH_SPACE)));
  }
}
