package org.elsfs.tool.sql.interfaces;

import org.elsfs.tool.sql.resolve.ResolveFieldName;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * the is {@link Expression}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface Expression<Children> extends ResolveFieldName {

  /**
   * 表达式匹配条件
   *
   * @param expression 表达式
   * @param args 表达式参数
   * @return 具体实现
   */
  Children expression(String expression, Object... args);

  /**
   * 表达式匹配条件
   *
   * @param condition 条件
   * @param expression 表达式
   * @param args 表达式参数
   * @return 具体实现
   */
  default Children expression(boolean condition, String expression, Object... args) {
    if (condition) {
      return this.expression(expression, args);
    }

    return CastUtils.cast(this);
  }
}
