package org.elsfs.tool.sql.interfaces;

import java.util.Map;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * SQL参数管理器
 *
 * @author zeng
 * @since 0.0.4
 */
public interface SqlParameterManager {

  /**
   * 注册SQL参数
   *
   * @param value 参数值
   * @return 参数名称
   */
  String registerParameter(Object value);

  /**
   * 获取SQL参数
   *
   * @return SQL参数
   */
  Map<String, Object> getSqlParameters();

  /**
   * 构建参数占位符
   *
   * @param parameterName 参数名称
   * @return 参数占位符
   */
  static String buildParameterPlaceholder(String parameterName) {
    return SqlPool.HASH_LEFT_BRACE + parameterName + SqlPool.RIGHT_BRACE;
  }
}
