package org.elsfs.tool.sql.interfaces;

import java.io.Serializable;

/**
 * 表别名管理器
 *
 * @author zeng
 * @since 0.0.4
 */
public interface TableAliasManager extends Serializable {

  /**
   * 生成表别名
   *
   * @param entityClass 表实体类
   * @return 别名
   */
  String generateAlias(Class<?> entityClass);

  /**
   * 生成表别名
   *
   * @param table 数据库表名
   * @return 别名
   */
  String generateAlias(String table);

  /**
   * 注册表别名
   *
   * @param entityClass 表实体类
   * @param alias 别名
   */
  void registerAlias(Class<?> entityClass, String alias);

  /**
   * 注册表别名
   *
   * @param table 数据库表名
   * @param alias 别名
   */
  void registerAlias(String table, String alias);

  /**
   * 获取表别名
   *
   * @param entityClass 表实体类
   * @return 表别名
   */
  String fetchTableAlias(Class<?> entityClass);

  /**
   * 获取表别名
   *
   * @param table 数据库表名
   * @return 表别名
   */
  String fetchTableAlias(String table);
}
