package org.elsfs.tool.sql.interfaces.delete;

import java.util.Collection;
import org.elsfs.tool.sql.interfaces.Completable;
import org.elsfs.tool.sql.interfaces.SortableCondition;
import org.elsfs.tool.sql.interfaces.SqlFragment;

/**
 * 删除SQL
 *
 * @param <C> 子类具体类型
 * @param <B> 删除条件构建器类型
 * @author zeng
 * @since 0.0.4
 */
public interface DeleteSql<
        C extends DeleteSql<C, B>, B extends DeleteSql.DeleteConditionBuilder<B, C>>
    extends SqlFragment {

  /**
   * 删除数据的表别名
   *
   * @param tableAlias 表别名
   * @return 具体实现
   */
  C delete(String tableAlias);

  /**
   * 删除数据的表别名
   *
   * @param tableAliases 表别名
   * @return 具体实现
   */
  C delete(String... tableAliases);

  /**
   * 删除数据的表别名
   *
   * @param tableAliases 表别名
   * @return 具体实现
   */
  C delete(Collection<String> tableAliases);

  /**
   * 设置删除数据的表
   *
   * @param entityClass 实体类
   * @return 具体实现
   */
  C from(Class<?> entityClass);

  /**
   * 设置删除数据的表
   *
   * @param table 表名
   * @return 具体实现
   */
  C from(String table);

  /**
   * 设置删除数据的表
   *
   * @param entityClass 实体类
   * @param tableAlias 表别名
   * @return 具体实现
   */
  C from(Class<?> entityClass, String tableAlias);

  /**
   * 设置删除数据的表
   *
   * @param table 表名
   * @param tableAlias 表别名
   * @return 具体实现
   */
  C from(String table, String tableAlias);

  /**
   * 设置删除条件
   *
   * @return 条件构建器
   */
  DeleteConditionBuilder<B, C> where();

  /**
   * 删除条件构建器
   *
   * @param <C> 具体实现
   * @param <P> 上级对象类型
   */
  interface DeleteConditionBuilder<
          C extends DeleteConditionBuilder<C, P>, P extends DeleteSql<P, C>>
      extends SortableCondition<C>, Completable<P> {}
}
