package org.elsfs.tool.sql.interfaces.join;

import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * 之间
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinBetween<Children> extends ResolveFieldName {

  /**
   * 区间条件
   *
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  default Children between(String leftField, String beginField, String endField) {
    return between(true, leftField, beginField, endField);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  Children between(boolean condition, String leftField, String beginField, String endField);

  /**
   * 区间条件
   *
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children between(String leftField, Enum<?> beginField, Enum<?> endField) {
    return between(true, leftField, beginField, endField);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children between(
      boolean condition, String leftField, Enum<?> beginField, Enum<?> endField) {
    return between(condition, leftField, resolveFieldName(beginField), resolveFieldName(endField));
  }

  /**
   * 区间条件
   *
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children between(String leftField, String beginField, Enum<?> endField) {
    return between(true, leftField, beginField, endField);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children between(
      boolean condition, String leftField, String beginField, Enum<?> endField) {
    return between(condition, leftField, beginField, resolveFieldName(endField));
  }

  /**
   * 区间条件
   *
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  default Children between(String leftField, Enum<?> beginField, String endField) {
    return between(true, leftField, beginField, endField);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  default Children between(
      boolean condition, String leftField, Enum<?> beginField, String endField) {
    return between(condition, leftField, resolveFieldName(beginField), endField);
  }

  /**
   * 区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children between(Enum<?> leftField, Enum<?> beginField, Enum<?> endField) {
    return between(true, leftField, beginField, endField);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children between(
      boolean condition, Enum<?> leftField, Enum<?> beginField, Enum<?> endField) {
    return between(
        condition,
        resolveFieldName(leftField),
        resolveFieldName(beginField),
        resolveFieldName(endField));
  }

  /**
   * 区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children between(Enum<?> leftField, String beginField, Enum<?> endField) {
    return between(true, leftField, beginField, endField);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children between(
      boolean condition, Enum<?> leftField, String beginField, Enum<?> endField) {
    return between(condition, resolveFieldName(leftField), beginField, resolveFieldName(endField));
  }

  /**
   * 区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段
   * @return 具体实现
   */
  default Children between(Enum<?> leftField, Enum<?> beginField, String endField) {
    return between(true, leftField, beginField, endField);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段
   * @return 具体实现
   */
  default Children between(
      boolean condition, Enum<?> leftField, Enum<?> beginField, String endField) {
    return between(condition, resolveFieldName(leftField), resolveFieldName(beginField), endField);
  }

  /**
   * 区间条件
   *
   * @param leftField 左边字段名称
   * @param beginValue 区间开始值
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  default Children betweenBeginValue(String leftField, Object beginValue, String endField) {
    return betweenBeginValue(true, leftField, beginValue, endField);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginValue 区间开始值
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  Children betweenBeginValue(
      boolean condition, String leftField, Object beginValue, String endField);

  /**
   * 区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children betweenBeginValue(Enum<?> leftField, Object beginValue, Enum<?> endField) {
    return betweenBeginValue(true, leftField, beginValue, endField);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children betweenBeginValue(
      boolean condition, Enum<?> leftField, Object beginValue, Enum<?> endField) {
    return betweenBeginValue(
        condition, resolveFieldName(leftField), beginValue, resolveFieldName(endField));
  }

  /**
   * 区间条件
   *
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children betweenEndValue(String leftField, String beginField, Object endValue) {
    return betweenEndValue(true, leftField, beginField, endValue);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endValue 区间结束值
   * @return 具体实现
   */
  Children betweenEndValue(boolean condition, String leftField, String beginField, Object endValue);

  /**
   * 区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children betweenEndValue(Enum<?> leftField, Enum<?> beginField, Object endValue) {
    return betweenEndValue(true, leftField, beginField, endValue);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children betweenEndValue(
      boolean condition, Enum<?> leftField, Enum<?> beginField, Object endValue) {
    return betweenEndValue(
        condition, resolveFieldName(leftField), resolveFieldName(beginField), endValue);
  }

  /**
   * 区间条件
   *
   * @param leftField 左边字段名称
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children betweenValue(String leftField, Object beginValue, Object endValue) {
    return betweenValue(true, leftField, beginValue, endValue);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  Children betweenValue(boolean condition, String leftField, Object beginValue, Object endValue);

  /**
   * 区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children betweenValue(Enum<?> leftField, Object beginValue, Object endValue) {
    return betweenValue(true, leftField, beginValue, endValue);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children betweenValue(
      boolean condition, Enum<?> leftField, Object beginValue, Object endValue) {
    return betweenValue(condition, resolveFieldName(leftField), beginValue, endValue);
  }

  /**
   * 区间条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children betweenValue(
      String leftTableAlias, Enum<?> leftField, Object beginValue, Object endValue) {
    return betweenValue(true, leftTableAlias, leftField, beginValue, endValue);
  }

  /**
   * 区间条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children betweenValue(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      Object beginValue,
      Object endValue) {
    return betweenValue(
        condition, resolveFieldName(leftTableAlias, leftField), beginValue, endValue);
  }
}
