package org.elsfs.tool.sql.interfaces.join;

import java.util.function.Consumer;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * 大于条件
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinGt<Children> extends ResolveFieldName {

  /**
   * 大于条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children gt(String leftField, String rightField) {
    return gt(true, leftField, rightField);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  Children gt(boolean condition, String leftField, String rightField);

  /**
   * 大于条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(Enum<?> leftField, Enum<?> rightField) {
    return gt(true, leftField, rightField);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(boolean condition, Enum<?> leftField, Enum<?> rightField) {
    return gt(condition, resolveFieldName(leftField), resolveFieldName(rightField));
  }

  /**
   * 大于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(
      String leftTableAlias, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return gt(true, leftTableAlias, leftField, rightTableAlias, rightField);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      String rightTableAlias,
      Enum<?> rightField) {
    return gt(
        condition,
        resolveFieldName(leftTableAlias, leftField),
        resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 大于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return gt(true, leftTableAlias, leftField, rightField);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(
      boolean condition, String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return gt(condition, resolveFieldName(leftTableAlias, leftField), resolveFieldName(rightField));
  }

  /**
   * 大于条件
   *
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return gt(true, leftField, rightTableAlias, rightField);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(
      boolean condition, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return gt(
        condition, resolveFieldName(leftField), resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 大于条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(String leftField, Enum<?> rightField) {
    return gt(true, leftField, rightField);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(boolean condition, String leftField, Enum<?> rightField) {
    return gt(condition, leftField, resolveFieldName(rightField));
  }

  /**
   * 大于条件
   *
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(String leftField, String rightTableAlias, Enum<?> rightField) {
    return gt(true, leftField, rightTableAlias, rightField);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children gt(
      boolean condition, String leftField, String rightTableAlias, Enum<?> rightField) {
    return gt(condition, leftField, resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 大于条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children gt(Enum<?> leftField, String rightField) {
    return gt(true, leftField, rightField);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children gt(boolean condition, Enum<?> leftField, String rightField) {
    return gt(condition, resolveFieldName(leftField), rightField);
  }

  /**
   * 大于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children gt(String leftTableAlias, Enum<?> leftField, String rightField) {
    return gt(true, leftTableAlias, leftField, rightField);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children gt(
      boolean condition, String leftTableAlias, Enum<?> leftField, String rightField) {
    return gt(condition, resolveFieldName(leftTableAlias, leftField), rightField);
  }

  /**
   * 大于条件
   *
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children gt(String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return gt(true, leftField, sqlBuilderConsumer);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  Children gt(boolean condition, String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer);

  /**
   * 大于条件
   *
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children gt(Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return gt(true, leftField, sqlBuilderConsumer);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children gt(
      boolean condition, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return gt(condition, resolveFieldName(leftField), sqlBuilderConsumer);
  }

  /**
   * 大于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children gt(
      String leftTableAlias, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return gt(true, leftTableAlias, leftField, sqlBuilderConsumer);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children gt(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return gt(condition, resolveFieldName(leftTableAlias, leftField), sqlBuilderConsumer);
  }

  /**
   * 大于条件
   *
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children gtValue(String leftField, Object rightValue) {
    return gtValue(true, leftField, rightValue);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  Children gtValue(boolean condition, String leftField, Object rightValue);

  /**
   * 大于条件
   *
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children gtValue(Enum<?> leftField, Object rightValue) {
    return gtValue(true, leftField, rightValue);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children gtValue(boolean condition, Enum<?> leftField, Object rightValue) {
    return gtValue(condition, resolveFieldName(leftField), rightValue);
  }

  /**
   * 大于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children gtValue(String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return gtValue(true, leftTableAlias, leftField, rightValue);
  }

  /**
   * 大于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children gtValue(
      boolean condition, String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return gtValue(condition, resolveFieldName(leftTableAlias, leftField), rightValue);
  }
}
