package org.elsfs.tool.sql.interfaces.join;

import java.util.function.Consumer;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.resolve.ResolveFieldName;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * the is
 *
 * @author zeng
 * @since
 */
public interface JoinIsNotNull<Children> extends ResolveFieldName {

  /**
   * 非空条件
   *
   * @param field 字段名称
   * @return 具体实现
   */
  Children isNotNull(String field);

  /**
   * 非空条件
   *
   * @param field 字段枚举
   * @return 具体实现
   */
  default Children isNotNull(Enum<?> field) {
    return this.isNotNull(this.resolveFieldName(field));
  }

  /**
   * 非空条件
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return 具体实现
   */
  default Children isNotNull(String tableAlias, Enum<?> field) {
    return this.isNotNull(this.resolveFieldName(tableAlias, field));
  }

  /**
   * 非空条件
   *
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  Children isNotNull(Consumer<StandardSelectSql> sqlBuilderConsumer);

  /**
   * 非空条件
   *
   * @param condition 条件
   * @param field 字段名称
   * @return 具体实现
   */
  default Children isNotNull(boolean condition, String field) {
    if (condition) {
      return this.isNotNull(field);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非空条件
   *
   * @param condition 条件
   * @param field 字段枚举
   * @return 具体实现
   */
  default Children isNotNull(boolean condition, Enum<?> field) {
    if (condition) {
      return this.isNotNull(field);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非空条件
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return 具体实现
   */
  default Children isNotNull(boolean condition, String tableAlias, Enum<?> field) {
    if (condition) {
      return this.isNotNull(tableAlias, field);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非空条件
   *
   * @param condition 条件
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children isNotNull(boolean condition, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    if (condition) {
      return this.isNotNull(sqlBuilderConsumer);
    }

    return CastUtils.cast(this);
  }
}
