package org.elsfs.tool.sql.interfaces.join;

import java.util.function.Consumer;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * 小于等于
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinLe<Children> extends ResolveFieldName {

  /**
   * 小于等于条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children le(String leftField, String rightField) {
    return le(true, leftField, rightField);
  }

  /**
   * 小于等于条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  Children le(boolean condition, String leftField, String rightField);

  /**
   * 小于等于条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(Enum<?> leftField, Enum<?> rightField) {
    return le(true, leftField, rightField);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(boolean condition, Enum<?> leftField, Enum<?> rightField) {
    return le(condition, resolveFieldName(leftField), resolveFieldName(rightField));
  }

  /**
   * 小于等于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(
      String leftTableAlias, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return le(true, leftTableAlias, leftField, rightTableAlias, rightField);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      String rightTableAlias,
      Enum<?> rightField) {
    return le(
        condition,
        resolveFieldName(leftTableAlias, leftField),
        resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 小于等于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return le(true, leftTableAlias, leftField, rightField);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(
      boolean condition, String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return le(condition, resolveFieldName(leftTableAlias, leftField), resolveFieldName(rightField));
  }

  /**
   * 小于等于条件
   *
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return le(true, leftField, rightTableAlias, rightField);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(
      boolean condition, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return le(
        condition, resolveFieldName(leftField), resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 小于等于条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(String leftField, Enum<?> rightField) {
    return le(true, leftField, rightField);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(boolean condition, String leftField, Enum<?> rightField) {
    return le(condition, leftField, resolveFieldName(rightField));
  }

  /**
   * 小于等于条件
   *
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(String leftField, String rightTableAlias, Enum<?> rightField) {
    return le(true, leftField, rightTableAlias, rightField);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children le(
      boolean condition, String leftField, String rightTableAlias, Enum<?> rightField) {
    return le(condition, leftField, resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 小于等于条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children le(Enum<?> leftField, String rightField) {
    return le(true, leftField, rightField);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children le(boolean condition, Enum<?> leftField, String rightField) {
    return le(condition, resolveFieldName(leftField), rightField);
  }

  /**
   * 小于等于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children le(String leftTableAlias, Enum<?> leftField, String rightField) {
    return le(true, leftTableAlias, leftField, rightField);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children le(
      boolean condition, String leftTableAlias, Enum<?> leftField, String rightField) {
    return le(condition, resolveFieldName(leftTableAlias, leftField), rightField);
  }

  /**
   * 小于等于条件
   *
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children le(String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return le(true, leftField, sqlBuilderConsumer);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  Children le(boolean condition, String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer);

  /**
   * 小于等于条件
   *
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children le(Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return le(true, leftField, sqlBuilderConsumer);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children le(
      boolean condition, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return le(condition, resolveFieldName(leftField), sqlBuilderConsumer);
  }

  /**
   * 小于等于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children le(
      String leftTableAlias, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return le(true, leftTableAlias, leftField, sqlBuilderConsumer);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children le(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return le(condition, resolveFieldName(leftTableAlias, leftField), sqlBuilderConsumer);
  }

  /**
   * 小于等于条件
   *
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children leValue(String leftField, Object rightValue) {
    return leValue(true, leftField, rightValue);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  Children leValue(boolean condition, String leftField, Object rightValue);

  /**
   * 小于等于条件
   *
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children leValue(Enum<?> leftField, Object rightValue) {
    return leValue(true, leftField, rightValue);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children leValue(boolean condition, Enum<?> leftField, Object rightValue) {
    return leValue(condition, resolveFieldName(leftField), rightValue);
  }

  /**
   * 小于等于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children leValue(String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return leValue(true, leftTableAlias, leftField, rightValue);
  }

  /**
   * 小于等于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children leValue(
      boolean condition, String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return leValue(condition, resolveFieldName(leftTableAlias, leftField), rightValue);
  }
}
