package org.elsfs.tool.sql.interfaces.join;

import org.elsfs.tool.sql.resolve.ResolveFieldName;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * the is {@link JoinLike}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinLike<Children> extends ResolveFieldName {

  /**
   * 模糊匹配条件
   *
   * @param field 字段名称
   * @param value 匹配值
   * @return 具体实现
   */
  Children like(String field, String value);

  /**
   * 模糊匹配条件
   *
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children like(Enum<?> field, String value);

  /**
   * 模糊匹配条件
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children like(String tableAlias, Enum<?> field, String value);

  /**
   * 模糊匹配条件
   *
   * @param condition 条件
   * @param field 字段名称
   * @param value 匹配值
   * @return 具体实现
   */
  default Children like(boolean condition, String field, String value) {
    if (condition) {
      return this.like(field, value);
    }

    return CastUtils.cast(this);
  }

  /**
   * 模糊匹配条件
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  default Children like(boolean condition, Enum<?> field, String value) {
    if (condition) {
      return this.like(field, value);
    }

    return CastUtils.cast(this);
  }

  /**
   * 模糊匹配条件
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  default Children like(boolean condition, String tableAlias, Enum<?> field, String value) {
    if (condition) {
      return this.like(tableAlias, field, value);
    }

    return CastUtils.cast(this);
  }
}
