package org.elsfs.tool.sql.interfaces.join;

import org.elsfs.tool.sql.resolve.ResolveFieldName;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * the is {@link JoinLikeRight}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinLikeRight<Children> extends ResolveFieldName {

  /**
   * 右模糊匹配条件
   *
   * @param field 字段名称
   * @param value 匹配值
   * @return 具体实现
   */
  Children likeRight(String field, String value);

  /**
   * 右模糊匹配条件
   *
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children likeRight(Enum<?> field, String value);

  /**
   * 右模糊匹配条件
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children likeRight(String tableAlias, Enum<?> field, String value);

  /**
   * 右模糊匹配条件
   *
   * @param condition 条件
   * @param field 字段名称
   * @param value 匹配值
   * @return 具体实现
   */
  default Children likeRight(boolean condition, String field, String value) {
    if (condition) {
      return this.likeRight(field, value);
    }

    return CastUtils.cast(this);
  }

  /**
   * 右模糊匹配条件
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  default Children likeRight(boolean condition, Enum<?> field, String value) {
    if (condition) {
      return this.likeRight(field, value);
    }

    return CastUtils.cast(this);
  }

  /**
   * 右模糊匹配条件
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  default Children likeRight(boolean condition, String tableAlias, Enum<?> field, String value) {
    if (condition) {
      return this.likeRight(tableAlias, field, value);
    }

    return CastUtils.cast(this);
  }
}
