package org.elsfs.tool.sql.interfaces.join;

import java.util.function.Consumer;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * 小于
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinLt<Children> extends ResolveFieldName {

  /**
   * 小于条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children lt(String leftField, String rightField) {
    return lt(true, leftField, rightField);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  Children lt(boolean condition, String leftField, String rightField);

  /**
   * 小于条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(Enum<?> leftField, Enum<?> rightField) {
    return lt(true, leftField, rightField);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(boolean condition, Enum<?> leftField, Enum<?> rightField) {
    return lt(condition, resolveFieldName(leftField), resolveFieldName(rightField));
  }

  /**
   * 小于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(
      String leftTableAlias, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return lt(true, leftTableAlias, leftField, rightTableAlias, rightField);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      String rightTableAlias,
      Enum<?> rightField) {
    return lt(
        condition,
        resolveFieldName(leftTableAlias, leftField),
        resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 小于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return lt(true, leftTableAlias, leftField, rightField);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(
      boolean condition, String leftTableAlias, Enum<?> leftField, Enum<?> rightField) {
    return lt(condition, resolveFieldName(leftTableAlias, leftField), resolveFieldName(rightField));
  }

  /**
   * 小于条件
   *
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return lt(true, leftField, rightTableAlias, rightField);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(
      boolean condition, Enum<?> leftField, String rightTableAlias, Enum<?> rightField) {
    return lt(
        condition, resolveFieldName(leftField), resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 小于条件
   *
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(String leftField, Enum<?> rightField) {
    return lt(true, leftField, rightField);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(boolean condition, String leftField, Enum<?> rightField) {
    return lt(condition, leftField, resolveFieldName(rightField));
  }

  /**
   * 小于条件
   *
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(String leftField, String rightTableAlias, Enum<?> rightField) {
    return lt(true, leftField, rightTableAlias, rightField);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightTableAlias 右边字段表别名
   * @param rightField 右边字段枚举
   * @return 具体实现
   */
  default Children lt(
      boolean condition, String leftField, String rightTableAlias, Enum<?> rightField) {
    return lt(true, leftField, resolveFieldName(rightTableAlias, rightField));
  }

  /**
   * 小于条件
   *
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children lt(Enum<?> leftField, String rightField) {
    return lt(true, leftField, rightField);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children lt(boolean condition, Enum<?> leftField, String rightField) {
    return lt(condition, resolveFieldName(leftField), rightField);
  }

  /**
   * 小于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children lt(String leftTableAlias, Enum<?> leftField, String rightField) {
    return lt(true, leftTableAlias, leftField, rightField);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightField 右边字段名称
   * @return 具体实现
   */
  default Children lt(
      boolean condition, String leftTableAlias, Enum<?> leftField, String rightField) {
    return lt(condition, resolveFieldName(leftTableAlias, leftField), rightField);
  }

  /**
   * 小于条件
   *
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children lt(String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return lt(true, leftField, sqlBuilderConsumer);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  Children lt(boolean condition, String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer);

  /**
   * 小于条件
   *
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children lt(Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return lt(true, leftField, sqlBuilderConsumer);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children lt(
      boolean condition, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return lt(condition, resolveFieldName(leftField), sqlBuilderConsumer);
  }

  /**
   * 小于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children lt(
      String leftTableAlias, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return lt(true, leftTableAlias, leftField, sqlBuilderConsumer);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children lt(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return lt(condition, resolveFieldName(leftTableAlias, leftField), sqlBuilderConsumer);
  }

  /**
   * 小于条件
   *
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children ltValue(String leftField, Object rightValue) {
    return ltValue(true, leftField, rightValue);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightValue 右边值
   * @return 具体实现
   */
  Children ltValue(boolean condition, String leftField, Object rightValue);

  /**
   * 小于条件
   *
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children ltValue(Enum<?> leftField, Object rightValue) {
    return ltValue(true, leftField, rightValue);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children ltValue(boolean condition, Enum<?> leftField, Object rightValue) {
    return ltValue(condition, resolveFieldName(leftField), rightValue);
  }

  /**
   * 小于条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children ltValue(String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return ltValue(true, leftTableAlias, leftField, rightValue);
  }

  /**
   * 小于条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValue 右边值
   * @return 具体实现
   */
  default Children ltValue(
      boolean condition, String leftTableAlias, Enum<?> leftField, Object rightValue) {
    return ltValue(condition, resolveFieldName(leftTableAlias, leftField), rightValue);
  }
}
