package org.elsfs.tool.sql.interfaces.join;

import org.elsfs.tool.sql.resolve.ResolveFieldName;

/**
 * 不在区间
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinNotBetween<Children> extends ResolveFieldName {

  /**
   * 非区间条件
   *
   * @param leftField 左边字段名称a
   * @param beginField 区间开始字段名称
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  default Children notBetween(String leftField, String beginField, String endField) {
    return notBetween(true, leftField, beginField, endField);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  Children notBetween(boolean condition, String leftField, String beginField, String endField);

  /**
   * 非区间条件
   *
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children notBetween(String leftField, Enum<?> beginField, Enum<?> endField) {
    return notBetween(true, leftField, beginField, endField);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children notBetween(
      boolean condition, String leftField, Enum<?> beginField, Enum<?> endField) {
    return notBetween(
        condition, leftField, resolveFieldName(beginField), resolveFieldName(endField));
  }

  /**
   * 非区间条件
   *
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children notBetween(String leftField, String beginField, Enum<?> endField) {
    return notBetween(true, leftField, beginField, endField);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children notBetween(
      boolean condition, String leftField, String beginField, Enum<?> endField) {
    return notBetween(condition, leftField, beginField, resolveFieldName(endField));
  }

  /**
   * 非区间条件
   *
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  default Children notBetween(String leftField, Enum<?> beginField, String endField) {
    return notBetween(true, leftField, beginField, endField);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  default Children notBetween(
      boolean condition, String leftField, Enum<?> beginField, String endField) {
    return notBetween(condition, leftField, resolveFieldName(beginField), endField);
  }

  /**
   * 非区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children notBetween(Enum<?> leftField, Enum<?> beginField, Enum<?> endField) {
    return notBetween(true, leftField, beginField, endField);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children notBetween(
      boolean condition, Enum<?> leftField, Enum<?> beginField, Enum<?> endField) {
    return notBetween(
        condition,
        resolveFieldName(leftField),
        resolveFieldName(beginField),
        resolveFieldName(endField));
  }

  /**
   * 非区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children notBetween(Enum<?> leftField, String beginField, Enum<?> endField) {
    return notBetween(true, leftField, beginField, endField);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段名称
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children notBetween(
      boolean condition, Enum<?> leftField, String beginField, Enum<?> endField) {
    return notBetween(
        condition, resolveFieldName(leftField), beginField, resolveFieldName(endField));
  }

  /**
   * 非区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段
   * @return 具体实现
   */
  default Children notBetween(Enum<?> leftField, Enum<?> beginField, String endField) {
    return notBetween(true, leftField, beginField, endField);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  default Children notBetween(
      boolean condition, Enum<?> leftField, Enum<?> beginField, String endField) {
    return notBetween(
        condition, resolveFieldName(leftField), resolveFieldName(beginField), endField);
  }

  /**
   * 非区间条件
   *
   * @param leftField 左边字段名称
   * @param beginValue 区间开始值
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  default Children notBetweenBeginValue(String leftField, Object beginValue, String endField) {
    return notBetweenBeginValue(true, leftField, beginValue, endField);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginValue 区间开始值
   * @param endField 区间结束字段名称
   * @return 具体实现
   */
  Children notBetweenBeginValue(
      boolean condition, String leftField, Object beginValue, String endField);

  /**
   * 非区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children notBetweenBeginValue(Enum<?> leftField, Object beginValue, Enum<?> endField) {
    return notBetweenBeginValue(true, leftField, beginValue, endField);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endField 区间结束字段枚举
   * @return 具体实现
   */
  default Children notBetweenBeginValue(
      boolean condition, Enum<?> leftField, Object beginValue, Enum<?> endField) {
    return notBetweenBeginValue(
        condition, resolveFieldName(leftField), beginValue, resolveFieldName(endField));
  }

  /**
   * 非区间条件
   *
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children notBetweenEndValue(String leftField, String beginField, Object endValue) {
    return notBetweenEndValue(true, leftField, beginField, endValue);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginField 区间开始字段名称
   * @param endValue 区间结束值
   * @return 具体实现
   */
  Children notBetweenEndValue(
      boolean condition, String leftField, String beginField, Object endValue);

  /**
   * 非区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children notBetweenEndValue(Enum<?> leftField, Enum<?> beginField, Object endValue) {
    return notBetweenEndValue(true, leftField, beginField, endValue);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginField 区间开始字段枚举
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children notBetweenEndValue(
      boolean condition, Enum<?> leftField, Enum<?> beginField, Object endValue) {
    return notBetweenEndValue(
        condition, resolveFieldName(leftField), resolveFieldName(beginField), endValue);
  }

  /**
   * 非区间条件
   *
   * @param leftField 左边字段名称
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children notBetweenValue(String leftField, Object beginValue, Object endValue) {
    return notBetweenValue(true, leftField, beginValue, endValue);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  Children notBetweenValue(boolean condition, String leftField, Object beginValue, Object endValue);

  /**
   * 非区间条件
   *
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children notBetweenValue(Enum<?> leftField, Object beginValue, Object endValue) {
    return notBetweenValue(true, leftField, beginValue, endValue);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children notBetweenValue(
      boolean condition, Enum<?> leftField, Object beginValue, Object endValue) {
    return notBetweenValue(condition, resolveFieldName(leftField), beginValue, endValue);
  }

  /**
   * 非区间条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children notBetweenValue(
      String leftTableAlias, Enum<?> leftField, Object beginValue, Object endValue) {
    return notBetweenValue(true, leftField, beginValue, endValue);
  }

  /**
   * 非区间条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param beginValue 区间开始值
   * @param endValue 区间结束值
   * @return 具体实现
   */
  default Children notBetweenValue(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      Object beginValue,
      Object endValue) {
    return notBetweenValue(
        condition, resolveFieldName(leftTableAlias, leftField), beginValue, endValue);
  }
}
