package org.elsfs.tool.sql.interfaces.join;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.resolve.ResolveFieldName;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * not in
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinNotIn<Children> extends ResolveFieldName {

  /**
   * 非范围条件
   *
   * @param leftField 左边字段名称
   * @param rightFields 范围字段名称
   * @return 具体实现
   */
  Children notIn(String leftField, String... rightFields);

  /**
   * 非范围条件
   *
   * @param leftField 左边字段枚举
   * @param rightFields 范围字段枚举
   * @return 具体实现
   */
  default Children notIn(Enum<?> leftField, Enum<?>... rightFields) {
    return this.notIn(
        this.resolveFieldName(leftField),
        Arrays.stream(rightFields).map(this::resolveFieldName).toArray(String[]::new));
  }

  /**
   * 非范围条件
   *
   * @param leftField 左边字段名称
   * @param rightFields 范围字段名称
   * @return 具体实现
   */
  Children notIn(String leftField, Collection<String> rightFields);

  /**
   * 非范围条件
   *
   * @param leftField 左边字段枚举
   * @param rightFields 范围字段枚举
   * @return 具体实现
   */
  default Children notIn(Enum<?> leftField, Collection<Enum<?>> rightFields) {
    return this.notIn(
        this.resolveFieldName(leftField),
        rightFields.stream().map(this::resolveFieldName).collect(Collectors.toSet()));
  }

  /**
   * 非范围条件
   *
   * @param leftField 左边字段名称
   * @param rightFields 范围字段名称
   * @param rightValues 范围值
   * @return 具体实现
   */
  Children notIn(String leftField, Collection<String> rightFields, Collection<?> rightValues);

  /**
   * 非范围条件
   *
   * @param leftField 左边字段枚举
   * @param rightFields 范围字段枚举
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notIn(
      Enum<?> leftField, Collection<Enum<?>> rightFields, Collection<?> rightValues) {
    return this.notIn(
        this.resolveFieldName(leftField),
        rightFields.stream().map(this::resolveFieldName).collect(Collectors.toSet()),
        rightValues);
  }

  /**
   * 非范围条件
   *
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  Children notIn(String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer);

  /**
   * 非范围条件
   *
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children notIn(Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return this.notIn(this.resolveFieldName(leftField), sqlBuilderConsumer);
  }

  /**
   * 非范围条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children notIn(
      String leftTableAlias, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    return this.notIn(this.resolveFieldName(leftTableAlias, leftField), sqlBuilderConsumer);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightFields 范围字段名称
   * @return 具体实现
   */
  default Children notIn(boolean condition, String leftField, String... rightFields) {
    if (condition) {
      return this.notIn(leftField, rightFields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightFields 范围字段枚举
   * @return 具体实现
   */
  default Children notIn(boolean condition, Enum<?> leftField, Enum<?>... rightFields) {
    if (condition) {
      return this.notIn(leftField, rightFields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightFields 范围字段名称
   * @return 具体实现
   */
  default Children notIn(boolean condition, String leftField, Collection<String> rightFields) {
    if (condition) {
      return this.notIn(leftField, rightFields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightFields 范围字段枚举
   * @return 具体实现
   */
  default Children notIn(boolean condition, Enum<?> leftField, Collection<Enum<?>> rightFields) {
    if (condition) {
      return this.notIn(leftField, rightFields);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightFields 范围字段名称
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notIn(
      boolean condition,
      String leftField,
      Collection<String> rightFields,
      Collection<?> rightValues) {
    if (condition) {
      return this.notIn(leftField, rightFields, rightValues);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightFields 范围字段枚举
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notIn(
      boolean condition,
      Enum<?> leftField,
      Collection<Enum<?>> rightFields,
      Collection<?> rightValues) {
    if (condition) {
      return this.notIn(leftField, rightFields, rightValues);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children notIn(
      boolean condition, String leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    if (condition) {
      return this.notIn(leftField, sqlBuilderConsumer);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children notIn(
      boolean condition, Enum<?> leftField, Consumer<StandardSelectSql> sqlBuilderConsumer) {
    if (condition) {
      return this.notIn(leftField, sqlBuilderConsumer);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param sqlBuilderConsumer SQL构建器消费器
   * @return 具体实现
   */
  default Children notIn(
      boolean condition,
      String leftTableAlias,
      Enum<?> leftField,
      Consumer<StandardSelectSql> sqlBuilderConsumer) {
    if (condition) {
      return this.notIn(leftTableAlias, leftField, sqlBuilderConsumer);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param leftField 左边字段名称
   * @param rightValues 范围值
   * @return 具体实现
   */
  Children notInValue(String leftField, Object... rightValues);

  /**
   * 非范围条件
   *
   * @param leftField 左边字段枚举
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notInValue(Enum<?> leftField, Object... rightValues) {
    return this.notInValue(this.resolveFieldName(leftField), rightValues);
  }

  /**
   * 非范围条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notInValue(String leftTableAlias, Enum<?> leftField, Object... rightValues) {
    return this.notInValue(this.resolveFieldName(leftTableAlias, leftField), rightValues);
  }

  /**
   * 非范围条件
   *
   * @param leftField 左边字段名称
   * @param rightValues 范围值
   * @return 具体实现
   */
  Children notInValue(String leftField, Collection<?> rightValues);

  /**
   * 非范围条件
   *
   * @param leftField 左边字段枚举
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notInValue(Enum<?> leftField, Collection<?> rightValues) {
    return this.notInValue(this.resolveFieldName(leftField), rightValues);
  }

  /**
   * 非范围条件
   *
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notInValue(String leftTableAlias, Enum<?> leftField, Collection<?> rightValues) {
    return this.notInValue(this.resolveFieldName(leftTableAlias, leftField), rightValues);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notInValue(boolean condition, String leftField, Object... rightValues) {
    if (condition) {
      return this.notInValue(leftField, rightValues);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notInValue(boolean condition, Enum<?> leftField, Object... rightValues) {
    if (condition) {
      return this.notInValue(leftField, rightValues);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notInValue(
      boolean condition, String leftTableAlias, Enum<?> leftField, Object... rightValues) {
    if (condition) {
      return this.notInValue(leftTableAlias, leftField, rightValues);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段名称
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notInValue(boolean condition, String leftField, Collection<?> rightValues) {
    if (condition) {
      return this.notInValue(leftField, rightValues);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftField 左边字段枚举
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notInValue(boolean condition, Enum<?> leftField, Collection<?> rightValues) {
    if (condition) {
      return this.notInValue(leftField, rightValues);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非范围条件
   *
   * @param condition 条件
   * @param leftTableAlias 左边字段表别名
   * @param leftField 左边字段枚举
   * @param rightValues 范围值
   * @return 具体实现
   */
  default Children notInValue(
      boolean condition, String leftTableAlias, Enum<?> leftField, Collection<?> rightValues) {
    if (condition) {
      return this.notInValue(leftTableAlias, leftField, rightValues);
    }

    return CastUtils.cast(this);
  }
}
