package org.elsfs.tool.sql.interfaces.join;

import org.elsfs.tool.sql.resolve.ResolveFieldName;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * the is {@link JoinNotLikeLeft}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface JoinNotLikeLeft<Children> extends ResolveFieldName {

  /**
   * 非左模糊匹配条件
   *
   * @param field 字段名称
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeLeft(String field, String value);

  /**
   * 非左模糊匹配条件
   *
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeLeft(Enum<?> field, String value);

  /**
   * 非左模糊匹配条件
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  Children notLikeLeft(String tableAlias, Enum<?> field, String value);

  /**
   * 非左模糊匹配条件
   *
   * @param condition 条件
   * @param field 字段名称
   * @param value 匹配值
   * @return 具体实现
   */
  default Children notLikeLeft(boolean condition, String field, String value) {
    if (condition) {
      return this.notLikeLeft(field, value);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非左模糊匹配条件
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  default Children notLikeLeft(boolean condition, Enum<?> field, String value) {
    if (condition) {
      return this.notLikeLeft(field, value);
    }

    return CastUtils.cast(this);
  }

  /**
   * 非左模糊匹配条件
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 匹配值
   * @return 具体实现
   */
  default Children notLikeLeft(boolean condition, String tableAlias, Enum<?> field, String value) {
    if (condition) {
      return this.notLikeLeft(tableAlias, field, value);
    }

    return CastUtils.cast(this);
  }
}
