package org.elsfs.tool.sql.interfaces.single;

/**
 * the is {@link IsNull}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface IsNull<Children> {

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param field 字段
   * @return children
   */
  Children isNull(String field);

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param field 字段枚举
   * @return children
   */
  Children isNull(Enum<?> field);

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return children
   */
  Children isNull(String tableAlias, Enum<?> field);

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param condition 执行条件
   * @param field 字段
   * @return children
   */
  Children isNull(boolean condition, String field);

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param condition 执行条件
   * @param field 字段枚举
   * @return children
   */
  Children isNull(boolean condition, Enum<?> field);

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param condition 执行条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return children
   */
  Children isNull(boolean condition, String tableAlias, Enum<?> field);
}
