package org.elsfs.tool.sql.interfaces.update;

import org.elsfs.tool.sql.interfaces.Completable;
import org.elsfs.tool.sql.interfaces.SortableCondition;
import org.elsfs.tool.sql.interfaces.SqlFragment;

/**
 * 更新SQL
 *
 * @param <C> 子类具体类型
 * @param <B> 更新条件构建器类型
 * @author zeng
 * @since 0.0.4
 */
public interface UpdateSql<
        C extends UpdateSql<C, B>, B extends UpdateSql.UpdateConditionBuilder<B, C>>
    extends Settable<C>, SqlFragment {

  /**
   * 设置更新数据的表
   *
   * @param entityClass 实体类
   * @return 具体实现
   */
  C update(Class<?> entityClass);

  /**
   * 设置更新数据的表
   *
   * @param table 表名
   * @return 具体实现
   */
  C update(String table);

  /**
   * 设置更新数据的表
   *
   * @param entityClass 实体类
   * @param tableAlias 表别名
   * @return 具体实现
   */
  C update(Class<?> entityClass, String tableAlias);

  /**
   * 设置更新数据的表
   *
   * @param table 表名
   * @param tableAlias 表别名
   * @return 具体实现
   */
  C update(String table, String tableAlias);

  /**
   * 设置更新条件
   *
   * @return 更新条件构建器
   */
  UpdateConditionBuilder<B, C> where();

  /**
   * 更新条件构建器
   *
   * @param <C> 具体实现
   * @param <P> 上级对象类型
   */
  interface UpdateConditionBuilder<
          C extends UpdateConditionBuilder<C, P>, P extends UpdateSql<P, C>>
      extends SortableCondition<C>, Completable<P> {}
}
