package org.elsfs.tool.sql.offset;

import org.elsfs.tool.core.text.StrFormatter;

/**
 * 标准偏移量实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class StandardOffsetItem implements OffsetItem {

  /** 便宜数量 */
  private final long number;

  public StandardOffsetItem(long number) {
    this.number = number;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format("OFFSET {}", this.number);
  }
}
