package org.elsfs.tool.sql.union;

import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.builder.StandardSelectSql;
import org.elsfs.tool.sql.interfaces.UnionType;

/**
 * 标准联合项实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class StandardUnionItem implements UnionItem {

  /** 查询SQL对象 */
  private final StandardSelectSql standardSelectSql;

  /** 联合类型 */
  private final UnionType unionType;

  public StandardUnionItem(StandardSelectSql standardSelectSql, UnionType unionType) {
    this.standardSelectSql = standardSelectSql;
    this.unionType = unionType;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} ({})", this.unionType.getUnionKeyword(), this.standardSelectSql.buildSqlFragment());
  }
}
