package org.elsfs.tool.sql.update;

import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

/**
 * 标准更新设置项实现
 *
 * @author zeng
 * @version 0.0.4
 */
public class StandardSetItem implements SetItem {

  /** SQL参数管理器 */
  protected final SqlParameterManager sqlParameterManager;

  /** 字段名称 */
  private final String field;

  /** 字段值 */
  private final Object value;

  /**
   * 构造函数
   *
   * @param sqlParameterManager SQL参数管理器
   * @param field 字段名称
   * @param value 值
   */
  public StandardSetItem(SqlParameterManager sqlParameterManager, String field, Object value) {
    this.sqlParameterManager = sqlParameterManager;
    this.field = field;
    this.value = value;
  }

  /**
   * 构建SQL片段
   *
   * @return SQL片段
   */
  @Override
  public String buildSqlFragment() {
    return StrFormatter.format(
        "{} = {}",
        NamingCase.toUnderlineCase(this.field),
        SqlParameterManager.buildParameterPlaceholder(
            this.sqlParameterManager.registerParameter(this.value)));
  }
}
