/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.abs;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.abs.AbstractSortableCondition;
import org.elsfs.tool.sql.condition.ConditionItem;
import org.elsfs.tool.sql.interfaces.SqlFragment;
import org.elsfs.tool.sql.interfaces.TokenSqlFragment;
import org.elsfs.tool.sql.limit.LimitItem;
import org.elsfs.tool.sql.order.CompositeOrderItem;
import org.elsfs.tool.sql.order.OrderItem;

public abstract class AbstractSortableConditionBuilder<C extends AbstractSortableConditionBuilder<C>>
extends AbstractSortableCondition<C> {
    private final List<ConditionItem> conditionItems = new ArrayList<ConditionItem>();
    private final List<OrderItem> orderItems = new ArrayList<OrderItem>();
    private LimitItem limitItem;

    @Override
    protected void addConditionItem(ConditionItem conditionItem) {
        this.conditionItems.add(conditionItem);
    }

    @Override
    protected void addOrderItem(OrderItem orderItem) {
        this.orderItems.add(orderItem);
    }

    @Override
    protected void setLimitItem(LimitItem limitItem) {
        this.limitItem = limitItem;
    }

    @Override
    protected void beforeBuild() {
        if (!this.conditionItems.isEmpty()) {
            this.addSqlFragment(new TokenSqlFragment(StrFormatter.format((String)"WHERE {}", (Object[])new Object[]{ConditionItem.stripHeaderKeywordStatic(this.conditionItems.stream().map(SqlFragment::buildSqlFragment).collect(Collectors.joining(" ")))})));
        }
        if (!this.orderItems.isEmpty()) {
            this.addSqlFragment(new CompositeOrderItem(this.orderItems));
        }
        if (this.limitItem != null) {
            this.addSqlFragment(this.limitItem);
        }
    }
}

