/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.condition;

import java.util.List;
import java.util.stream.Collectors;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.condition.ConditionItem;
import org.elsfs.tool.sql.interfaces.SqlFragment;

public class CompositeConditionItem
implements ConditionItem {
    private final List<ConditionItem> conditions;

    public CompositeConditionItem(List<ConditionItem> conditions) {
        this.conditions = conditions;
    }

    @Override
    public String buildSqlFragment() {
        if (this.conditions.isEmpty()) {
            return "";
        }
        String conditionSql = this.conditions.stream().map(SqlFragment::buildSqlFragment).collect(Collectors.joining(" "));
        if (this.conditions.size() == 1) {
            return this.stripHeaderKeyword(conditionSql);
        }
        return StrFormatter.format((String)"({})", (Object[])new Object[]{this.stripHeaderKeyword(conditionSql)});
    }
}

