/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.condition;

import java.util.ArrayList;
import java.util.Collection;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.condition.ConditionItem;
import org.elsfs.tool.sql.interfaces.SqlParameterManager;

public class InConditionItem
implements ConditionItem {
    protected final SqlParameterManager sqlParameterManager;
    protected final String leftField;
    protected final Collection<String> inFields;
    protected final Collection<?> inValues;

    public InConditionItem(SqlParameterManager sqlParameterManager, String leftField, Collection<String> inFields, Collection<?> inValues) {
        this.sqlParameterManager = sqlParameterManager;
        this.leftField = leftField;
        this.inFields = inFields;
        this.inValues = inValues;
    }

    @Override
    public String buildSqlFragment() {
        ArrayList<String> tokens = new ArrayList<String>();
        if (this.inFields != null) {
            for (String inField : this.inFields) {
                tokens.add(NamingCase.toUnderlineCase((CharSequence)inField));
            }
        }
        if (this.inValues != null) {
            for (String inValue : this.inValues) {
                tokens.add(SqlParameterManager.buildParameterPlaceholder(this.sqlParameterManager.registerParameter(inValue)));
            }
        }
        return this.buildSqlFragment(String.join((CharSequence)", ", tokens));
    }

    protected String buildSqlFragment(String token) {
        return StrFormatter.format((String)"{} IN ({})", (Object[])new Object[]{NamingCase.toUnderlineCase((CharSequence)this.leftField), token});
    }
}

