/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.select;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.select.SelectItem;

public class StandardSelectItem
implements SelectItem {
    private static final Pattern FIELD_ALIAS_SPLITTING_PATTERN = Pattern.compile("( +as +(?=\\w+$))|( +(?=\\w+$))", 2);
    private final String tableAlias;
    private final String field;
    private final String fieldAlias;

    public StandardSelectItem(String tableAlias, String field, String fieldAlias) {
        this.tableAlias = tableAlias;
        this.field = field;
        this.fieldAlias = fieldAlias;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getField() {
        return this.field;
    }

    public String getFieldAlias() {
        return this.fieldAlias;
    }

    public StandardSelectItem(String field) {
        String[] tokens;
        List<String> parts;
        if (StrUtils.isBlank((String)field)) {
            throw new SqlBuilderException("\u9009\u62e9\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String alias = null;
        if (field.contains(".") && (parts = Arrays.stream(field.split(".")).toList()).size() == 2) {
            alias = parts.get(0);
            field = parts.get(1);
        }
        if ((tokens = FIELD_ALIAS_SPLITTING_PATTERN.split(field)).length == 0) {
            throw new SqlBuilderException("\u9009\u62e9\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tokens.length == 1) {
            this.tableAlias = alias;
            this.field = tokens[0];
            this.fieldAlias = null;
            return;
        }
        this.tableAlias = alias;
        this.field = tokens[0];
        this.fieldAlias = tokens[1];
    }

    @Override
    public String buildSqlFragment() {
        StringBuilder stringBuilder = new StringBuilder();
        if (StrUtils.isNotBlank((String)this.tableAlias)) {
            stringBuilder.append(this.tableAlias).append(".");
        }
        if (StrUtils.isBlank((String)this.fieldAlias)) {
            stringBuilder.append(NamingCase.toUnderlineCase((CharSequence)this.field));
        } else {
            stringBuilder.append(NamingCase.toUnderlineCase((CharSequence)this.field)).append(" AS ").append(NamingCase.toUnderlineCase((CharSequence)this.fieldAlias));
        }
        return stringBuilder.toString();
    }
}

