/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.singular.facade;

import java.util.Set;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.sql.common.FieldEnumResolverSupport;
import org.elsfs.tool.sql.interfaces.TableAliasManager;

public class ConditionFields {
    private final Set<String> fieldNames;
    private final TableAliasManager tableAliasManager;

    public ConditionFields(Set<String> fieldNames, TableAliasManager tableAliasManager) {
        this.fieldNames = fieldNames;
        this.tableAliasManager = tableAliasManager;
    }

    public boolean hasField(String field) {
        return this.fieldNames.contains(NamingCase.toUnderlineCase((CharSequence)field));
    }

    public boolean hasField(String tableAlias, String field) {
        return this.fieldNames.contains(tableAlias + "." + NamingCase.toUnderlineCase((CharSequence)field));
    }

    public boolean hasField(Class<?> entityClass, String field) {
        return this.fieldNames.contains(this.tableAliasManager.fetchTableAlias(entityClass) + "." + NamingCase.toUnderlineCase((CharSequence)field));
    }

    public boolean hasField(Enum<?> field) {
        return this.fieldNames.contains(NamingCase.toUnderlineCase((CharSequence)FieldEnumResolverSupport.resolveFieldName(this.tableAliasManager, field)));
    }
}

