package org.elsfs.tool.core.page;

import java.util.Collection;
import java.util.List;

/**
 * 分页
 *
 * @author zeng
 * @version 0.0.4
 */
public interface IPage<T> {

  /**
   * 设置当前分页数
   *
   * @param current 当前分页数
   */
  void setCurrent(long current);

  /**
   * 获取当前分页数
   *
   * @return 当前分页数
   */
  long getCurrent();
  /**
   * 设置分页大小
   *
   * @param size 分页大小
   */
  void setSize(long size);

  /**
   * 获取分页大小
   *
   * @return 分页大小
   */
  long getSize();

  /**
   * 设置获取总记录数
   *
   * @param total 总记录数
   */
   void setTotal(long total);

  /**
   * 获取总记录数
   *
   * @return 总记录数
   */
  long getTotal();

  /**
   * 获取 分页数据
   *
   * @return 分页数据
   */
  List<T> getRecords();

  /**
   * 设置 分页数据
   *
   * @param records 数据
   */
  void setRecords(List<T> records);




  /**
   * 分页大小
   *
   * @return 分页大小
   */
  long getPageSize();
}
